*********************************
* IMPORT NEXIS					*
* Author: Emanuele Ciani		*
* This version: 1/7/2021		*
*********************************

***********
* AUSTRIA *
***********
* Die Presse (from 23/04/2004 onwards only), Der Standard (from 01/01/2008 onwards only), Austria Today (up to 31/12/2014)
import excel "$nexis/Austria/Die Presse pensionsreform 1_1000.XLSX", sheet("News") clear firstrow
g newspaper="Die Presse"
save austria, replace
import excel "$nexis/Austria/Die Presse pensionsreform 1001_1196.XLSX", sheet("News") clear firstrow
g newspaper="Die Presse"
append using austria
save austria, replace
import excel "$nexis/Austria/Der Standard pensionsreform 1_340.XLSX", sheet("News") clear firstrow
g newspaper="Der Standard"
append using austria
save austria, replace
import excel "$nexis/Austria/Austria Today pension reform 1_45.XLSX", sheet("News") clear firstrow
g newspaper="Austria Today"
append using austria
save austria, replace

use austria, clear
chartab Publisheddate, noascii
replace Publisheddate=lower(ustrto(ustrnormalize(Publisheddate, "nfd"), "ascii", 2))
chartab Publisheddate, noascii

* Some are in German, some in English
* We remove the day of the week
foreach day in montag dienstag mittwoch donnerstag freitag samstag sonntag {
	replace Publisheddate = subinstr(Publisheddate,"`day'", "", .)
}
foreach day in monday tuesday wednesday thursday friday saturday sunday {
	replace Publisheddate = subinstr(Publisheddate,"`day'", "", .)
}

replace Publisheddate = subinstr(Publisheddate,"januar", "january", .)
replace Publisheddate = subinstr(Publisheddate,"februar", "february", .)
replace Publisheddate = subinstr(Publisheddate,"marz", "march", .)
replace Publisheddate = subinstr(Publisheddate,"april", "april", .)
replace Publisheddate = subinstr(Publisheddate,"mai", "may", .)
replace Publisheddate = subinstr(Publisheddate,"juni", "june", .)
replace Publisheddate = subinstr(Publisheddate,"juli", "july", .)
replace Publisheddate = subinstr(Publisheddate,"august", "august", .)
replace Publisheddate = subinstr(Publisheddate,"september", "september", .)
replace Publisheddate = subinstr(Publisheddate,"oktober", "october", .)
replace Publisheddate = subinstr(Publisheddate,"november", "november", .)
replace Publisheddate = subinstr(Publisheddate,"dezember", "december", .)
* beware of the issues for the English versions
replace Publisheddate = subinstr(Publisheddate,"januaryy", "january", .)
replace Publisheddate = subinstr(Publisheddate,"februaryy", "february", .)

generate publisheddate=date(Publisheddate,"DMY")
* those in English are in a different format
replace publisheddate=date(Publisheddate,"MDY") if publisheddate==.
format publisheddate %d
g country="austria"
save austria, replace

*******************
* BELGIUM		  *
*******************
* Trends magazine (weekly, from 01/06/2007 onwards only). Belgium has nothing available before 2007
import excel "$nexis/Belgium/Trends pensioenhervorming OR pensioenhervormingen 1_100.XLSX", sheet("News") clear firstrow
g newspaper="Trends Magazine"
save belgium, replace

use belgium, clear
chartab Publisheddate, noascii
replace Publisheddate=lower(ustrto(ustrnormalize(Publisheddate, "nfd"), "ascii", 2))
chartab Publisheddate, noascii

* Note: all dates in English MDY
g publisheddate=date(Publisheddate,"MDY")
format publisheddate %d
g country="belgium"
save belgium, replace

***********
* DENMARK *
***********
* Politiken (daily and weekly). Only newspaper available in Denmark
import excel "$nexis/Denmark/Politiken pensionsreformer OR pensionsreform 1_189.XLSX", sheet("News") clear firstrow
g newspaper="Politiken"
save denmark, replace

use denmark, clear
chartab Publisheddate, noascii
* the ø is not replaced, we keep it
replace Publisheddate=lower(Publisheddate)

* Note: some are in Danish, some in English
foreach day in mandag tirsdag onsdag torsdag fredag lørdag søndag {
	replace Publisheddate = subinstr(Publisheddate,"`day'", "", .)
}

replace Publisheddate = subinstr(Publisheddate,"januar ", "january ", .)
replace Publisheddate = subinstr(Publisheddate,"februar ", "february ", .)
replace Publisheddate = subinstr(Publisheddate,"marts", "march", .)
replace Publisheddate = subinstr(Publisheddate,"april", "april", .)
replace Publisheddate = subinstr(Publisheddate,"maj", "may", .)
replace Publisheddate = subinstr(Publisheddate,"juni", "june", .)
replace Publisheddate = subinstr(Publisheddate,"juli", "july", .)
replace Publisheddate = subinstr(Publisheddate,"august", "august", .)
replace Publisheddate = subinstr(Publisheddate,"september", "september", .)
replace Publisheddate = subinstr(Publisheddate,"oktober", "october", .)
replace Publisheddate = subinstr(Publisheddate,"november", "november", .)
replace Publisheddate = subinstr(Publisheddate,"december", "december", .)

generate publisheddate=date(Publisheddate,"DMY")
* those in English are in a different format
replace publisheddate=date(Publisheddate,"MDY") if publisheddate==.
format publisheddate %d
g country="denmark"
save denmark, replace


**********
* FRANCE *
**********
* Le Figaro (daily), Humanite (daily)
import excel "$nexis/France/Figaro reforme_des_retraites 1_1000.xlsx", sheet("News") clear firstrow
g newspaper="Figaro"
save france, replace
import excel "$nexis/France/Figaro reforme_des_retraites 1001_2000.xlsx", sheet("News") clear firstrow
g newspaper="Figaro"
append using france
save france, replace
import excel "$nexis/France/Figaro reforme_des_retraites 2001_3000.xlsx", sheet("News") clear firstrow
g newspaper="Figaro"
append using france
save france, replace
import excel "$nexis/France/Figaro reforme_des_retraites 3001_3497.xlsx", sheet("News") clear firstrow
g newspaper="Figaro"
append using france
save france, replace
import excel "$nexis/France/Humanite reforme_des_retraites 1_1000.xlsx", sheet("News") clear firstrow
g newspaper="Humanite"
append using france
save france, replace
import excel "$nexis/France/Humanite reforme_des_retraites 1001_2000.xlsx", sheet("News") clear firstrow
g newspaper="Humanite"
append using france
save france, replace
import excel "$nexis/France/Humanite reforme_des_retraites 2001_3000.xlsx", sheet("News") clear firstrow
g newspaper="Humanite"
append using france
save france, replace
import excel "$nexis/France/Humanite reforme_des_retraites 3001_3021.xlsx", sheet("News") clear firstrow
g newspaper="Humanite"
append using france
save france, replace

use france, clear
chartab Publisheddate, noascii
replace Publisheddate=lower(ustrto(ustrnormalize(Publisheddate, "nfd"), "ascii", 2))
chartab Publisheddate, noascii

foreach day in lundi mardi mercredi jeudi vendredi samedi dimanche {
	replace Publisheddate = subinstr(Publisheddate,"`day'", "", .)
}

replace Publisheddate = subinstr(Publisheddate,"janvier", "january", .)
replace Publisheddate = subinstr(Publisheddate,"fevrier", "february", .)
replace Publisheddate = subinstr(Publisheddate,"mars", "march", .)
replace Publisheddate = subinstr(Publisheddate,"avril", "april", .)
replace Publisheddate = subinstr(Publisheddate,"mai", "may", .)
replace Publisheddate = subinstr(Publisheddate,"juin", "june", .)
replace Publisheddate = subinstr(Publisheddate,"juillet", "july", .)
replace Publisheddate = subinstr(Publisheddate,"aout", "august", .)
replace Publisheddate = subinstr(Publisheddate,"septembre", "september", .)
replace Publisheddate = subinstr(Publisheddate,"octobre", "october", .)
replace Publisheddate = subinstr(Publisheddate,"novembre", "november", .)
replace Publisheddate = subinstr(Publisheddate,"decembre", "december", .)

generate publisheddate=date(Publisheddate,"DMY")
format publisheddate %d
g country="france"
save france, replace

***********
* GERMANY *
***********
* Die Welt (daily), Der Spiegel (weekly)
import excel "$nexis/Germany/Die Welt rentenreform 1_1000.XLSX", sheet("News") clear firstrow
g newspaper="Die Welt"
save germany, replace
import excel "$nexis/Germany/Die Welt rentenreform 1001_1433.XLSX", sheet("News") clear firstrow
g newspaper="Die Welt"
append using germany
save germany, replace
import excel "$nexis/Germany/Der Spiegel rentenreform 1_237.XLSX", sheet("News") clear firstrow
g newspaper="Der Spiegel"
append using germany
save germany, replace

use germany, clear
chartab Publisheddate, noascii
replace Publisheddate=lower(ustrto(ustrnormalize(Publisheddate, "nfd"), "ascii", 2))
chartab Publisheddate, noascii

* Some are already in English, without day of the week
foreach day in montag dienstag mittwoch donnerstag freitag samstag sonntag {
	replace Publisheddate = subinstr(Publisheddate,"`day'", "", .)
}

replace Publisheddate = subinstr(Publisheddate,"januar", "january", .)
replace Publisheddate = subinstr(Publisheddate,"februar", "february", .)
replace Publisheddate = subinstr(Publisheddate,"marz", "march", .)
replace Publisheddate = subinstr(Publisheddate,"maerz", "march", .)
replace Publisheddate = subinstr(Publisheddate,"april", "april", .)
replace Publisheddate = subinstr(Publisheddate,"mai", "may", .)
replace Publisheddate = subinstr(Publisheddate,"juni", "june", .)
replace Publisheddate = subinstr(Publisheddate,"juli", "july", .)
replace Publisheddate = subinstr(Publisheddate,"august", "august", .)
replace Publisheddate = subinstr(Publisheddate,"september", "september", .)
replace Publisheddate = subinstr(Publisheddate,"oktober", "october", .)
replace Publisheddate = subinstr(Publisheddate,"november", "november", .)
replace Publisheddate = subinstr(Publisheddate,"dezember", "december", .)

generate publisheddate=date(Publisheddate,"DMY")
* those in English are in a different format
replace publisheddate=date(Publisheddate,"MDY") if publisheddate==.
format publisheddate %d
g country="germany"
save germany, replace

***********
* ITALY	  *
***********
* La Stampa (daily), Milano Finanza (from 01/06/2004 onwards only)
import excel "$nexis/Italy/La Stampa riforma pensioni 1_1000.XLSX", sheet("News") clear firstrow
g newspaper="La Stampa"
save italy, replace
import excel "$nexis/Italy/La Stampa riforma pensioni 1001_2000.XLSX", sheet("News") clear firstrow
g newspaper="La Stampa"
append using italy
save italy, replace
import excel "$nexis/Italy/La Stampa riforma pensioni 2001_3000.XLSX", sheet("News") clear firstrow
g newspaper="La Stampa"
append using italy
save italy, replace
import excel "$nexis/Italy/La Stampa riforma pensioni 3001_3471.XLSX", sheet("News") clear firstrow
g newspaper="La Stampa"
append using italy
save italy, replace
import excel "$nexis/Italy/Milano Finanza riforma pensioni 1_495.XLSX", sheet("News") clear firstrow
g newspaper="Milano Finanza"
append using italy
save italy, replace

use italy, clear
chartab Publisheddate, noascii
replace Publisheddate=lower(ustrto(ustrnormalize(Publisheddate, "nfd"), "ascii", 2))
chartab Publisheddate, noascii

* Note: some are in Italian, some in English
foreach day in lunedi martedi mercoledi giovedi venerdi sabato domenica {
	replace Publisheddate = subinstr(Publisheddate,"`day'", "", .)
}

replace Publisheddate = subinstr(Publisheddate,"gennaio", "january", .)
replace Publisheddate = subinstr(Publisheddate,"febbraio", "february", .)
replace Publisheddate = subinstr(Publisheddate,"marzo", "march", .)
replace Publisheddate = subinstr(Publisheddate,"aprile", "april", .)
replace Publisheddate = subinstr(Publisheddate,"maggio", "may", .)
replace Publisheddate = subinstr(Publisheddate,"giugno", "june", .)
replace Publisheddate = subinstr(Publisheddate,"luglio", "july", .)
replace Publisheddate = subinstr(Publisheddate,"agosto", "august", .)
replace Publisheddate = subinstr(Publisheddate,"settembre", "september", .)
replace Publisheddate = subinstr(Publisheddate,"ottobre", "october", .)
replace Publisheddate = subinstr(Publisheddate,"novembre", "november", .)
replace Publisheddate = subinstr(Publisheddate,"dicembre", "december", .)

generate publisheddate=date(Publisheddate,"DMY")
* those in English are in a different format
replace publisheddate=date(Publisheddate,"MDY") if publisheddate==.
format publisheddate %d
g country="italy"
save italy, replace

*******************
* NETHERLANDS	  *
*******************
* De Telegraaf (daily), De Volkskrant (daily), NRC Handelsblad (De Volkskrant includes de Volksrant 1600 from May 31, 2006 through October 12, 2007)
import excel "$nexis/Netherlands/De Telegraaf pensioenhervorming OR pensioenhervormingen 1_46.XLSX", sheet("News") clear firstrow
g newspaper="De Telegraaf"
save netherlands, replace
import excel "$nexis/Netherlands/De Volkskrant pensioenhervorming OR pensioenhervormingen 1_125.XLSX", sheet("News") clear firstrow
g newspaper="De Volkskrant"
append using netherlands
save netherlands, replace
import excel "$nexis/Netherlands/NRC Handelsblad pensioenhervorming OR pensioenhervormingen 1_157.XLSX", sheet("News") clear firstrow
g newspaper="NRC Handelsblad"
append using netherlands
save netherlands, replace

use netherlands, clear
chartab Publisheddate, noascii
replace Publisheddate=lower(ustrto(ustrnormalize(Publisheddate, "nfd"), "ascii", 2))
chartab Publisheddate, noascii

* Note: some are in Dutch, some in English
* some also have the day in English at the end
foreach day in maandag dinsdag woensdag donderdag vrijdag zaterdag zondag {
	replace Publisheddate = subinstr(Publisheddate,"`day'", "", .)
}
foreach day in monday tuesday wednesday thursday friday saturday sunday {
	replace Publisheddate = subinstr(Publisheddate,"`day'", "", .)
}

replace Publisheddate = subinstr(Publisheddate,"januari", "january", .)
replace Publisheddate = subinstr(Publisheddate,"februari", "february", .)
replace Publisheddate = subinstr(Publisheddate,"maart", "march", .)
replace Publisheddate = subinstr(Publisheddate,"april", "april", .)
replace Publisheddate = subinstr(Publisheddate,"mei", "may", .)
replace Publisheddate = subinstr(Publisheddate,"juni", "june", .)
replace Publisheddate = subinstr(Publisheddate,"juli", "july", .)
replace Publisheddate = subinstr(Publisheddate,"augustus", "august", .)
replace Publisheddate = subinstr(Publisheddate,"september", "september", .)
replace Publisheddate = subinstr(Publisheddate,"oktober", "october", .)
replace Publisheddate = subinstr(Publisheddate,"november", "november", .)
replace Publisheddate = subinstr(Publisheddate,"december", "december", .)

generate publisheddate=date(Publisheddate,"DMY")
* those in English are in a different format
replace publisheddate=date(Publisheddate,"MDY") if publisheddate==.
format publisheddate %d
g country="netherlands"
save netherlands, replace

*******************
* SPAIN	  		  *
*******************
* El Pais (daily), El Mundo (from 01/01/2002 onwards only...)
import excel "$nexis/Spain/El Pais reforma near_5 pensiones 1_1000.XLSX", sheet("News") clear firstrow
g newspaper="El Pais"
save spain, replace
import excel "$nexis/Spain/El Pais reforma near_5 pensiones 1001_2000.XLSX", sheet("News") clear firstrow
g newspaper="El Pais"
append using spain
save spain, replace
import excel "$nexis/Spain/El Pais reforma near_5 pensiones 2001_2099.XLSX", sheet("News") clear firstrow
g newspaper="El Pais"
append using spain
save spain, replace
import excel "$nexis/Spain/El Mundo reforma near_5 pensiones 1_1000.XLSX", sheet("News") clear firstrow
g newspaper="El Mundo"
append using spain
save spain, replace
import excel "$nexis/Spain/El Mundo reforma near_5 pensiones 1001_1075.XLSX", sheet("News") clear firstrow
g newspaper="El Mundo"
append using spain
save spain, replace

use spain, clear
chartab Publisheddate, noascii
replace Publisheddate=lower(ustrto(ustrnormalize(Publisheddate, "nfd"), "ascii", 2))
chartab Publisheddate, noascii

* Note: they are all in English, but other newspapers may have them differently
foreach day in lunes martes miercoles jueves viernes sabado domingo {
	replace Publisheddate = subinstr(Publisheddate,"`day'", "", .)
}
* They have the day in English at the end
foreach day in monday tuesday wednesday thursday friday saturday sunday {
	replace Publisheddate = subinstr(Publisheddate,"`day'", "", .)
}

* As above
replace Publisheddate = subinstr(Publisheddate,"enero", "january", .)
replace Publisheddate = subinstr(Publisheddate,"febrero", "february", .)
replace Publisheddate = subinstr(Publisheddate,"marzo", "march", .)
replace Publisheddate = subinstr(Publisheddate,"abril", "april", .)
replace Publisheddate = subinstr(Publisheddate,"mayo", "may", .)
replace Publisheddate = subinstr(Publisheddate,"junio", "june", .)
replace Publisheddate = subinstr(Publisheddate,"julio", "july", .)
replace Publisheddate = subinstr(Publisheddate,"agosto", "august", .)
replace Publisheddate = subinstr(Publisheddate,"septiembre", "september", .)
replace Publisheddate = subinstr(Publisheddate,"octubre", "october", .)
replace Publisheddate = subinstr(Publisheddate,"noviembre", "november", .)
replace Publisheddate = subinstr(Publisheddate,"diciembre", "december", .)

generate publisheddate=date(Publisheddate,"DMY")
* those in English are in a different format
replace publisheddate=date(Publisheddate,"MDY") if publisheddate==.
format publisheddate %d
g country="spain"
save spain, replace

************************
* SWITZERLAND (German) *
************************
* Tages Anzeiger (daily), Neue Zurcher Zeitung (daily)
import excel "$nexis/Switzerland/Tages Anzeiger rentenreform 1_274.XLSX", sheet("News") clear firstrow
g newspaper="Tages Anzeiger"
save switzerland, replace
import excel "$nexis/Switzerland/Neue Zurcher Zeitung rentenreform 1_1000.XLSX", sheet("News") clear firstrow
g newspaper="Neue Zurcher Zeitung"
append using switzerland
save switzerland, replace
import excel "$nexis/Switzerland/Neue Zurcher Zeitung rentenreform 1001_1315.XLSX", sheet("News") clear firstrow
g newspaper="Neue Zurcher Zeitung"
append using switzerland
save switzerland, replace

use switzerland, clear
chartab Publisheddate, noascii
replace Publisheddate=lower(ustrto(ustrnormalize(Publisheddate, "nfd"), "ascii", 2))
chartab Publisheddate, noascii

foreach day in montag dienstag mittwoch donnerstag freitag samstag sonntag {
	replace Publisheddate = subinstr(Publisheddate,"`day'", "", .)
}

replace Publisheddate = subinstr(Publisheddate,"januar", "january", .)
replace Publisheddate = subinstr(Publisheddate,"februar", "february", .)
replace Publisheddate = subinstr(Publisheddate,"marz", "march", .)
replace Publisheddate = subinstr(Publisheddate,"maerz", "march", .)
replace Publisheddate = subinstr(Publisheddate,"april", "april", .)
replace Publisheddate = subinstr(Publisheddate,"mai", "may", .)
replace Publisheddate = subinstr(Publisheddate,"juni", "june", .)
replace Publisheddate = subinstr(Publisheddate,"juli", "july", .)
replace Publisheddate = subinstr(Publisheddate,"august", "august", .)
replace Publisheddate = subinstr(Publisheddate,"september", "september", .)
replace Publisheddate = subinstr(Publisheddate,"oktober", "october", .)
replace Publisheddate = subinstr(Publisheddate,"november", "november", .)
replace Publisheddate = subinstr(Publisheddate,"dezember", "december", .)

generate publisheddate=date(Publisheddate,"DMY")
* some are reversed
replace publisheddate=date(Publisheddate,"MDY") if publisheddate==.
format publisheddate %d
g country="switzerland"
save switzerland, replace

********************
* ASSEMBLING	   *
********************
use austria, clear
append using belgium
append using denmark
append using france
append using germany
append using italy
append using netherlands
append using spain
append using switzerland

tab country
ren country country_name
/* SHARE COUNTRY CODES
11 /*Austria*/
23 /*Belgium*/
18 /*Denmark*/
17 /*France*/
12 /*Germany*/
16 /*Italy*/
14 /*Netherlands*/
15 /*Spain*/
13 /*Sweden*/
20 /*Switzerland*/
*/
g country=11 if country_name=="austria"
replace country=23 if country_name=="belgium"
replace country=18 if country_name=="denmark"
replace country=17 if country_name=="france"
replace country=12 if country_name=="germany"
replace country=16 if country_name=="italy"
replace country=14 if country_name=="netherlands"
replace country=15 if country_name=="spain"
replace country=13 if country_name=="sweden"
replace country=20 if country_name=="switzerland"

g news_nexis=1

g tempo=mofd(publisheddate)
format tempo %tm

* Calculate sum of news by week - country - newspaper
collapse (sum) news_nexis, by(tempo country country_name newspaper)

encode newspaper, g(code_newspaper)
ren country_name country_name_nexis
ren newspaper newspaper_name_nexis
preserve
	bysort code_newspaper: keep if _n==1
	keep code_newspaper country country_name_nexis newspaper_name_nexis
	save canc, replace
restore

xtset code_newspaper tempo
tsfill, full
recode news_nexis .=0

drop country country_name_nexis newspaper_name_nexis
merge m:1 code_newspaper using canc
drop _merge


/*
    Austria - Die Presse (from 23/04/2004 onwards only), Der Standard (from 01/01/2008 onwards only...), Austria Today (up to 31/12/2014)
    Belgium - Trends magazine (weekly, from 01/06/2007 onwards only).   Belgium has nothing available before 2007
    Denmark - Politiken (daily and weekly).         Only newspaper available in Denmark.
    France  - Le Figaro (daily), Humanite (daily)
    Germany - Die Welt (daily), Der Spiegel (weekly)
    Italy   - La Stampa (daily), Milano Finanza (from 01/06/2004 onwards only...)
    Nether  - De Telegraaf (daily), De Volkskrant (daily), NRC Handelsblad      (De Volkskrant includes de Volksrant 1600 from May 31, 2006 through October 12, 2007)
    Spain   - El Pais (daily), El Mundo (from 01/01/2002 onwards only...)
    Switzer - Tages Anzeiger (daily), Neue Zurcher Zeitung (daily)
*/
* To get the correct mean, I replace as missing cases where the newspaper was not available
replace news_nexis=. if country_name_nexis=="austria" & newspaper_name_nexis=="Die Presse" & tempo<=mofd(date("23/04/2004","DMY")) /*we kept April because it is almost full */
replace news_nexis=. if country_name_nexis=="austria" & newspaper_name_nexis=="Der Standard" & tempo<mofd(date("01/01/2008","DMY"))
replace news_nexis=. if country_name_nexis=="austria" & newspaper_name_nexis=="Austria Today" & tempo>mofd(date("31/12/2014","DMY"))

replace news_nexis=. if country_name_nexis=="belgium" & newspaper_name_nexis=="Trends Magazine" & tempo<mofd(date("01/06/2007","DMY"))

replace news_nexis=. if country_name_nexis=="italy" & newspaper_name_nexis=="Milano Finanza" & tempo<mofd(date("01/06/2004","DMY"))

replace news_nexis=. if country_name_nexis=="spain" & newspaper_name_nexis=="El Mundo" & tempo<mofd(date("01/01/2002","DMY"))

g year=year(dofm(tempo))

tab year

keep if year>=2003 & year<=2013

* Adjust the weekly magazine for Germany: I bring Der Spiegel to the mean of Die Welt
sum news_nexis if country_name=="germany" & newspaper=="Die Welt"
local mean_die_welt=r(mean)
sum news_nexis if country_name=="germany" & newspaper=="Der Spiegel"
replace news_nexis=news_nexis*`mean_die_welt'/r(mean) if country_name=="germany" & newspaper=="Der Spiegel"
sum news_nexis if country_name=="germany" & newspaper=="Die Welt"
sum news_nexis if country_name=="germany" & newspaper=="Der Spiegel"

egen country_news=concat(country_name_nexis newspaper_name_nexis), punct(" ")
levelsof country_news, local(levels)
    foreach l of local levels {
		graph twoway (line news_nexis tempo if country_news=="`l'"), title("`l'") saving("`l'", replace)
		graph export "`l'.png", replace
	}
graph combine "austria Austria Today.gph" "austria Der Standard.gph" "austria Die Presse.gph" "belgium Trends Magazine.gph" "denmark Politiken.gph" "france Figaro.gph" "france Humanite.gph" "germany Der Spiegel.gph" "germany Die Welt.gph" "italy La Stampa.gph" "italy Milano Finanza.gph" "netherlands De Telegraaf.gph" "netherlands De Volkskrant.gph" "netherlands NRC Handelsblad.gph" "spain El Mundo.gph" "spain El Pais.gph" "switzerland Neue Zurcher Zeitung.gph" "switzerland Tages Anzeiger.gph", cols(3) iscale(.4) xsize(16.5) ysize(24) graphregion(margin(zero))
graph export "newspapers.png", replace width(1200)

* I take the mean by country, collapsing over available newspapers
collapse (mean) news_nexis, by(tempo country country_name)

egen mean_news=mean(news_nexis), by(country)
egen max_news=max(news_nexis), by(country)
egen sd_news=sd(news_nexis), by(country)
g news_nexis_rescmax=news_nexis/max_news
g news_nexis_std=(news_nexis-mean_news)/sd_news

* Smoothing
xtset country tempo

foreach var in news_nexis news_nexis_rescmax news_nexis_std {
    g `var'6=(`var'+l.`var'+l2.`var'+l3.`var'+l4.`var'+l5.`var')/6
    g L_`var'=l.`var'
    g L2_`var'=l2.`var'
    g L3_`var'=l3.`var'
    g L4_`var'=l4.`var'
    g L5_`var'=l5.`var'
}

levelsof country_name, local(levels)
    foreach l of local levels {
		graph twoway (line news_nexis tempo if country_name=="`l'") (line news_nexis_std tempo if country_name=="`l'", yaxis(2)), legend(label(1 "Raw") label(2 "Rescaled by max (axis rx)")) saving("`l'", replace) yscale(range(0 240) axis(1)) yscale(range(-1.2 7.6) axis(2)) ylabel(0(30)240, axis(1)) ylabel(-1.2(0.8)7.6, axis(2)) title("`l'")
		graph export "`l'.png", replace
	}
graph combine "austria.gph" "belgium.gph" "denmark.gph" "france.gph" "germany.gph" "italy.gph" "netherlands.gph" "spain.gph" "switzerland.gph", cols(3) iscale(.4) xsize(16.5) ysize(12) graphregion(margin(zero))
graph export "country_news.png", replace width(1200)

save "$input_ext/news_nexis.dta", replace
